## 关于指针 

指针是C语言的精华部分，同时也是表示链式存储结构的关键所在。理解了指针的基础概念，再理解单链表等链式数据结构就不再是个难题。

## 理解指针和指针变量  

变量是用来存放数据的，指针是内存地址，指针变量就是用来存放内存地址的变量。

```c
    // 声明一个整型变量age，值是17
    int age = 17;
    // 声明一个整型指针，指向变量age的地址， &符号可以理解为 <取地址符号>
    int *p = &age;
    printf("age的值：%d\n", age);
    printf("*p的值：%d\n", *p);
    printf("变量 age的地址：%p\n", &age);
    printf("指针p指向的地址：%p\n", p);
    printf("指针p自身的地址：%p\n", &p);
```

输出如下：  

```
    age的值：17  
    *p的值：17  
    变量 age的地址：000000000062FE1C  
    指针p指向的地址：000000000062FE1C  
    指针p自身的地址：000000000062FE10  
```

## 指针图解

![pointer.png][1]

## 关于内存  

你可能会对内存地址产生疑惑，可以大致这样理解。

|变量名|  内存地址   | 值  |
|  ---- |  ----  | ----  |
|age| 000000000062FE1C   | 17 |
|p| 000000000062FE10   | 000000000062FE1C |

整型指针变量p，存储的值是整型变量age的内存地址。  
符号`&`是取地址符，那么&age = 000000000062FE1C;由于指针变量本身也是一个变量，所以p也有一个自己的地址，对其取地址操作&p=000000000062FE10;
而`*p`则是获取指针变量p存储的值对应内存地址中存储的值。


  [1]: https://lookcos.cn/usr/uploads/2021/11/3435806864.png